uniform sampler2D texTo;
uniform sampler2D texFrom;
uniform sampler2D texCloud;

uniform float crossfader;
uniform float randomSeed;
uniform float levelFrom;
uniform float levelTo;

vec4 GetSample(vec4 border, sampler2D tex, vec2 uv, float level)
{
    vec2 clamped = clamp(uv,0.0,1.0) - uv;
	if (clamped.x>0.0 || clamped.y>0.0)
		return border;
  vec4 color=texture2D(tex, uv);
  color.a=level;
  return color;
}

void main()
{
	vec2 uv = gl_TexCoord[0].st;
  vec4 color = gl_Color;

  float offset = -texture2D(texCloud, vec2(uv.x / 5.0, randomSeed)).x;
	vec4 color1 = GetSample(vec4(0, 0, 0, 0), texFrom, vec2(uv.x, uv.y + offset * crossfader), levelFrom);
	vec4 color2 = texture2D(texTo, uv);
  color2.a = levelTo;

	if (color1.a <= 0.0)
		gl_FragColor = color2;
	else
		gl_FragColor = mix(color1, color2, crossfader);
}